/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.structure;

import com.terraforged.mod.api.material.state.States;
import com.terraforged.mod.structure.StructureTerrainResource;
import com.terraforged.noise.util.NoiseUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;

public class StructureTerrain {
    private static final Structure<?>[] EMPTY_ARRAY = new Structure[0];
    private static final int MIN_RADIUS = 4;
    private static final int MAX_RADIUS = 10;
    private final float radiusScale;
    private final float overhang;
    private final float overhang2;
    private final Structure<?>[] structures = StructureTerrain.getTerrainFitStructures().toArray(EMPTY_ARRAY);
    private final ThreadLocal<StructureTerrainResource> resource = ThreadLocal.withInitial(StructureTerrainResource::new);

    public StructureTerrain(float base, float cutout) {
        this.radiusScale = base;
        this.overhang = cutout;
        this.overhang2 = cutout * cutout;
    }

    public void apply(IWorld world, IChunk chunk) {
        StructureTerrainResource resource = this.resource.get().reset();
        this.collectPieces(world, chunk, resource);
        this.buildBases(chunk, resource);
    }

    private void collectPieces(IWorld world, IChunk chunk, StructureTerrainResource resource) {
        ChunkPos pos = chunk.func_76632_l();
        for (Structure<?> structure : this.structures) {
            LongSet set = (LongSet)chunk.func_201604_d().get(structure);
            if (set == null) continue;
            LongIterator structureIds = set.iterator();
            while (structureIds.hasNext()) {
                long id = structureIds.nextLong();
                ChunkPos structurePos = new ChunkPos(id);
                IChunk neighbourChunk = world.func_217349_x(structurePos.func_206849_h());
                StructureStart structureStart = (StructureStart)neighbourChunk.func_201609_c().get(structure);
                if (structureStart == null || !structureStart.func_75069_d()) continue;
                for (StructurePiece structurepiece : structureStart.func_186161_c()) {
                    if (!structurepiece.func_214810_a(pos, 16)) continue;
                    StructureTerrain.collectPiece(structurepiece, resource.pieces);
                }
            }
        }
    }

    private void buildBases(IChunk chunk, StructureTerrainResource resource) {
        int chunkStartX = chunk.func_76632_l().func_180334_c();
        int chunkStartZ = chunk.func_76632_l().func_180333_d();
        ObjectListIterator<StructurePiece> iterator = resource.iterator;
        BlockPos.Mutable mutablePos = resource.mutablePos;
        MutableBoundingBox utilBounds = resource.mutableBounds;
        MutableBoundingBox chunkBounds = StructureTerrain.assignChunk(resource.chunkBounds, chunkStartX, chunkStartZ);
        BlockState air = (BlockState)States.AIR.get();
        BlockState solid = (BlockState)States.STONE.get();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                MutableBoundingBox bounds;
                int x = chunkStartX + dx;
                int z = chunkStartZ + dz;
                int surface = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, dx, dz);
                float y = surface;
                int highestOffset = 0;
                StructurePiece highest = null;
                while (iterator.hasNext()) {
                    int length;
                    int borderRadius;
                    StructurePiece piece = (StructurePiece)iterator.next();
                    MutableBoundingBox pieceBounds = piece.func_74874_b();
                    if (!StructureTerrain.intersects(chunkBounds, pieceBounds, utilBounds, borderRadius = Math.min(4, Math.max(10, NoiseUtil.round((float)(length = Math.min(pieceBounds.field_78893_d - pieceBounds.field_78897_a, pieceBounds.field_78892_f - pieceBounds.field_78896_c)) * this.radiusScale))))) continue;
                    int offset = StructureTerrain.getGroundLevelDelta(piece);
                    int level = pieceBounds.field_78895_b + offset;
                    if ((float)level > y) {
                        y = StructureTerrain.raise(pieceBounds, mutablePos.func_181079_c(x, surface, z), level, y, borderRadius);
                    }
                    if (x <= pieceBounds.field_78897_a || x >= pieceBounds.field_78893_d || z <= pieceBounds.field_78896_c || z >= pieceBounds.field_78892_f || highest != null && pieceBounds.field_78895_b <= highest.func_74874_b().field_78895_b) continue;
                    highest = piece;
                    highestOffset = offset;
                }
                resource.rewind();
                if (y > (float)surface) {
                    int delta = (int)y - surface;
                    for (int dy = 0; dy < delta; ++dy) {
                        mutablePos.func_181079_c(dx, surface + dy, dz);
                        chunk.func_177436_a((BlockPos)mutablePos, solid, false);
                    }
                }
                if (highest == null) continue;
                int minY = bounds.field_78895_b + highestOffset;
                bounds = highest.func_74874_b();
                int maxY = minY + bounds.func_78882_c();
                if (maxY <= surface) {
                    float dist2 = StructureTerrain.getCenterDistance2(x, z, bounds);
                    float distAlpha = 1.0f - NoiseUtil.clamp(dist2 / this.overhang2, 0.0f, 1.0f);
                    float depth = surface - maxY;
                    float depthAlpha = 1.0f - NoiseUtil.clamp(depth / this.overhang, 0.0f, 1.0f);
                    maxY += NoiseUtil.round(depthAlpha * distAlpha * this.overhang);
                }
                for (int dy = minY; dy <= maxY; ++dy) {
                    mutablePos.func_181079_c(dx, dy, dz);
                    chunk.func_177436_a((BlockPos)mutablePos, air, false);
                }
            }
        }
    }

    private static boolean intersects(MutableBoundingBox chunk, MutableBoundingBox structure, MutableBoundingBox util, int radius) {
        StructureTerrain.expand(structure, util, radius);
        return chunk.func_78884_a(util);
    }

    private static void expand(MutableBoundingBox src, MutableBoundingBox dest, int radius) {
        dest.field_78895_b = src.field_78895_b;
        dest.field_78894_e = src.field_78894_e;
        dest.field_78897_a = src.field_78897_a - radius;
        dest.field_78896_c = src.field_78896_c - radius;
        dest.field_78893_d = src.field_78893_d + radius;
        dest.field_78892_f = src.field_78892_f + radius;
    }

    private static float raise(MutableBoundingBox bounds, BlockPos.Mutable pos, float level, float surface, int borderRadius) {
        float radius2 = Math.max(1, borderRadius * borderRadius);
        float distAlpha = 1.0f - StructureTerrain.getDistAlpha(pos.func_177958_n(), pos.func_177952_p(), bounds, radius2);
        float alpha = NoiseUtil.pow(distAlpha, 2.0f - distAlpha);
        return NoiseUtil.lerp(surface, level, alpha);
    }

    private static float getCenterDistance(int x, int z, MutableBoundingBox bounds) {
        return (float)Math.sqrt(StructureTerrain.getCenterDistance2(x, z, bounds));
    }

    private static float getCenterDistance2(int x, int z, MutableBoundingBox bounds) {
        float cx = (float)bounds.field_78897_a + (float)bounds.func_78883_b() / 2.0f;
        float cz = (float)bounds.field_78896_c + (float)bounds.func_78880_d() / 2.0f;
        float dx = cx - (float)x;
        float dz = cz - (float)z;
        return dx * dx + dz * dz;
    }

    private static void collectPiece(StructurePiece structurepiece, List<StructurePiece> list) {
        if (structurepiece instanceof AbstractVillagePiece) {
            AbstractVillagePiece piece = (AbstractVillagePiece)structurepiece;
            JigsawPattern.PlacementBehaviour placement = piece.func_214826_b().func_214854_c();
            if (placement == JigsawPattern.PlacementBehaviour.RIGID) {
                list.add((StructurePiece)piece);
            }
        } else {
            list.add(structurepiece);
        }
    }

    private static int getGroundLevelDelta(StructurePiece piece) {
        if (piece instanceof AbstractVillagePiece) {
            return ((AbstractVillagePiece)piece).func_214830_d();
        }
        return 0;
    }

    private static float getDistAlpha(int x, int z, MutableBoundingBox box, float radius2) {
        int dx;
        int n = x < box.field_78897_a ? box.field_78897_a - x : (dx = x > box.field_78893_d ? x - box.field_78893_d : 0);
        int dz = z < box.field_78896_c ? box.field_78896_c - z : (z > box.field_78892_f ? z - box.field_78892_f : 0);
        int d2 = dx * dx + dz * dz;
        if (d2 == 0) {
            return 0.0f;
        }
        if ((float)d2 > radius2) {
            return 1.0f;
        }
        return (float)d2 / radius2;
    }

    private static MutableBoundingBox assignChunk(MutableBoundingBox box, int startX, int startZ) {
        return StructureTerrain.assign2D(box, startX, startZ, startX + 15, startZ + 15);
    }

    private static MutableBoundingBox assign2D(MutableBoundingBox box, int x1, int z1, int x2, int z2) {
        return StructureTerrain.assign(box, x1, 0, z1, x2, 255, z2);
    }

    private static MutableBoundingBox assign(MutableBoundingBox box, int x1, int y1, int z1, int x2, int y2, int z2) {
        box.field_78897_a = x1;
        box.field_78893_d = x2;
        box.field_78895_b = y1;
        box.field_78894_e = y2;
        box.field_78896_c = z1;
        box.field_78892_f = z2;
        return box;
    }

    private static List<Structure<?>> getTerrainFitStructures() {
        return Structure.field_236384_t_;
    }
}

